'use strict';

$(function () {
  (function (o, h, d) {
    if (!o || !h) return false;
    var toggle = function (value) {
      _open.checked = !(typeof value === 'undefined') ? !value : true;
      $html[_open.checked ? "removeClass" : "addClass"]('sta-noScroll');
    };
    var _open = document.getElementById('sta-cookies'),
      cookieInputs = {},
      baseDefault = {
        'functional': false,
        'analytics': false,
        'publicity': false
      },
      $html = $('html'),
      cookie = JSON.parse(h.getCookie('controlCookies')),
      avoidCookiePage = location.pathname.split('/').slice(-1).pop() !== 'cookies.html';

    if (!cookie && avoidCookiePage) {
      cookie = Object.assign({}, baseDefault);
      toggle(true);
    };

    Object.keys(baseDefault).forEach(function (key) {
      var input = document.getElementById(key);
      if (input) {
        cookieInputs[key] = input;
        input.checked = cookie[key];
        $(input).change(function () {
          cookie[key] = this.checked;
        });
      };
    });

    $(o.querySelector('.fn-disableAll')).click(function () {
      for (var ele in cookieInputs) {
        cookieInputs[ele].checked = false;
        cookie[ele] = false;
      }
    });

    $(o.querySelector('.fn-enableAll')).click(function () {
      for (var ele in cookieInputs) {
        cookieInputs[ele].checked = true;
        cookie[ele] = true;
      }
    });
    
    $(o.querySelector('.sta-cookie_info .fn-confirm:not(.fn-disableAll)')).click(function () {
      for (var ele in cookieInputs) {
        cookieInputs[ele].checked = true;
        cookie[ele] = true;
      }
    });


    $(o.querySelectorAll('.fn-confirm')).click(function () {
      var dm = document.domain,
        dm = dm.indexOf('booking-channel.com') !== -1 ? dm : '.' + h.getDomain(dm);
      h.setCookie('controlCookies', JSON.stringify(cookie), undefined, dm, toggle);
      if (d) d.push({ 'event': 'controlCookies' });
    });


  })(document.querySelector('.tpl-cookie'), window.hotusa && hotusa(), window.dataLayer);
});
